package com.qboxus.tictic.adapters

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.interfaces.AdapterClickListener
import com.qboxus.tictic.models.HomeModel
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad
import com.qboxus.tictic.simpleclasses.Functions.getSuffix
import com.qboxus.tictic.simpleclasses.Functions.isStringHasValue
import com.qboxus.tictic.simpleclasses.Functions.printLog
import com.facebook.drawee.view.SimpleDraweeView
import com.qboxus.tictic.databinding.ItemMyvideoLayoutBinding
import com.qboxus.tictic.simpleclasses.MyViewHolder

/**
 * Created by qboxus on 3/20/2018.
 */
class MyVideosAdapter(
    var context: Context,
    private val dataList: MutableList<HomeModel>,
    var whereFrom: String,
    var adapterClickListener: AdapterClickListener
) : RecyclerView.Adapter<MyVideosAdapter.CustomViewHolder>() {
    override fun onCreateViewHolder(viewGroup: ViewGroup, viewtype: Int): CustomViewHolder {
        val binding: ItemMyvideoLayoutBinding = ItemMyvideoLayoutBinding.inflate(LayoutInflater.from(viewGroup.context),viewGroup,false)
        return CustomViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return dataList.size
    }

    override fun onBindViewHolder(holder: CustomViewHolder, i: Int) {
        val item = dataList[i]
        try {
            if (Constants.IS_SHOW_GIF) {
                holder.binding.thumbImage.controller =
                    frescoImageLoad(item.getGif(), holder.binding.thumbImage, true)
            } else if (isStringHasValue(item.getThum())) {
                holder.binding.thumbImage.controller =
                    frescoImageLoad(item.getThum(), holder.binding.thumbImage, false)
            }
        } catch (e: Exception) {
            printLog(Constants.tag, e.toString())
        }
        if (whereFrom == "myProfile") {
            if (item.pin == "1") {
                holder.binding.tabPinned.visibility = View.VISIBLE
            } else {
                holder.binding.tabPinned.visibility = View.GONE
            }
        } else {
            holder.binding.tabPinned.visibility = View.GONE
        }
        holder.binding.viewTxt.text = item.views
        holder.binding.viewTxt.text = getSuffix(item.views)
        holder.onBind(i, item, adapterClickListener)
    }

    inner class CustomViewHolder(val binding: ItemMyvideoLayoutBinding) : MyViewHolder(binding.root) {

        override fun onBind(pos: Int, item: Any?, listener: AdapterClickListener) {
            itemView.setOnClickListener { v: View? -> listener.onItemClick(v, pos, item) }
        }
    }
}